IF  EXISTS (SELECT * FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_EST_META_VENDEDOR_REALIZADO]'))
DROP VIEW [DBO].[V_EST_META_VENDEDOR_REALIZADO]
GO  
--VERSAO 2335
--SELECT * FROM V_EST_META_VENDEDOR_REALIZADO	WHERE CD_EMP = 1 AND CD_FILIAL =2 AND DT_VD ='2017-07-17'
CREATE VIEW [DBO].[V_EST_META_VENDEDOR_REALIZADO] WITH ENCRYPTION AS

SELECT 
	META.CD_EMP,
	META.CD_FILIAL,
	META.CD_VEND,
	ISNULL(FP_FUNC.NM_FUN,'Nao definido') AS NM_VENDEDOR,
	ISNULL(PRC_REGIAO_FILIAL.NM_REGIAO_FILIAL,'NAO DEFINIDO') AS NM_REGIAO_FILIAL,
	ISNULL(GLB_USU.NM_USU,'NAO DEFINIDO') AS NM_SUPERVISOR ,
	META.DT_VD,
	SUM(META.META_VD) META_VD,
	SUM(META.META_DESC) META_DESC,
	SUM(META.META_CUPONS) META_CUPONS,
	SUM(META.META_ITENS) META_ITENS,
	SUM(META.VLR_LIQ_VD) VLR_LIQ_VD,
	SUM(META.VLR_DESC) VLR_DESC,
	SUM(META.QT_CUPOM) QT_CUPOM,
	SUM(META.QT_ITENS) QT_ITENS ,
	SUM(META.VLR_CMV) AS VLR_CMV,
	SUM(META.VLR_CUSTO) AS VLR_CUSTO,
	SUM(META.VLR_CUSTO_GER) AS VLR_CUSTO_GER,
	META.VENDA_RECARGA,
	META.PERC_LUCRATIVIDADE,
	PRC_FILIAL.NM_FANT,
	GLB_CID.DS_CID,
	GLB_CID.UF,
	PRC_FILIAL.CEP,
	TIPO_VENDA
FROM
(
	SELECT 
		1 as CD_EMP,
		EST_MOVIMENTO_VENDAS.CD_FILIAL,
		EST_MOVIMENTO_VENDAS_PRODUTOS.CD_VEND,
		GLB_DT_MOVIMENTO.DT_MOVIMENTO AS DT_VD,
		0 AS META_VD,
		0 AS META_DESC,
		0 AS META_CUPONS,
		0 AS META_ITENS,
		SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ) AS VLR_LIQ_VD, 
		SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_OFERTA+EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_ITENS+EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_VERBA+EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_RATEIO) AS VLR_DESC,
		Q.QTDE_VD as QT_CUPOM,
		SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.QTDE_ITENS) AS QT_ITENS,
		SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_MD) AS VLR_CMV,
		SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO) AS VLR_CUSTO,
		SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_GER) AS VLR_CUSTO_GER,
		V_BI_MOVIMENTO_TIPO.DsTipoMovimento as VENDA_RECARGA,
		0 AS PERC_LUCRATIVIDADE,
		EST_MOVIMENTO_VENDAS.TIPO_VENDA
	FROM            
		EST_MOVIMENTO_VENDAS_PRODUTOS INNER JOIN EST_MOVIMENTO_VENDAS ON
		EST_MOVIMENTO_VENDAS_PRODUTOS.CD_CTR_VENDAS = EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
		INNER JOIN GLB_DT_MOVIMENTO ON
		EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
		INNER JOIN V_BI_MOVIMENTO_TIPO ON
		EST_MOVIMENTO_VENDAS.TIPO_VENDA = V_BI_MOVIMENTO_TIPO.TipoMovimento
			CROSS APPLY (SELECT CUPONS.CD_VEND, SUM(CUPONS.QTDE_VD) AS QTDE_VD
						FROM (
								SELECT V.CD_ORIGEM_VENDA,
									   V.CD_VEND,
									   V.QTDE_VD
								FROM EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_VENDEDOR V
								INNER JOIN EST_MOVIMENTO_VENDAS_PRODUTOS P ON P.CD_CTR_VENDAS = V.CD_CTR_VENDAS AND
																			P.CD_ORIGEM_VENDA = V.CD_ORIGEM_VENDA AND
																			P.CD_VEND = V.CD_VEND
								WHERE V.CD_CTR_VENDAS = EST_MOVIMENTO_VENDAS_PRODUTOS.CD_CTR_VENDAS
								AND V.CD_VEND = EST_MOVIMENTO_VENDAS_PRODUTOS.CD_VEND
								GROUP BY  V.CD_ORIGEM_VENDA,
									   V.CD_VEND,
									   V.QTDE_VD
							) CUPONS
						GROUP BY CUPONS.CD_VEND) Q
	WHERE
		EST_MOVIMENTO_VENDAS.TIPO_VENDA IN (0,2,3,10,11)
	GROUP BY
		EST_MOVIMENTO_VENDAS.CD_FILIAL,
		V_BI_MOVIMENTO_TIPO.DsTipoMovimento,
		GLB_DT_MOVIMENTO.DT_MOVIMENTO,
		EST_MOVIMENTO_VENDAS.TIPO_VENDA,
		EST_MOVIMENTO_VENDAS_PRODUTOS.CD_VEND,
		Q.QTDE_VD
	UNION ALL
	SELECT
			M.CD_EMP,
			MF.CD_FILIAL,
			MF.CD_VEND,
			M.DT_META,
			M.VLR_VD		META_VD,
			M.VLR_DESC		META_DESC,
			M.QTDE_CUPONS	META_CUPONS,
			M.QTDE_ITENS	META_ITENS,
    		0  AS VLR_LIQ_VD, 
			0  AS VLR_DESC, 
			0  AS QT_CUPOM, 
			0  AS QT_ITENS,
			0 AS VLR_CMV,
			0 AS VLR_CUSTO,
			0 AS VLR_CUSTO_GER,
			'Meta Vendas' AS VENDA_RECARGA
			,0 AS PERC_LUCRATIVIDADE,
			0 TIPO_VENDA
		FROM		
			EST_META_VEND_CPL M INNER JOIN EST_META_VEND MF ON
			M.CD_EMP           = MF.CD_EMP AND
			M.CD_META		   = MF.CD_META) META 
		
		
		
		
		
			LEFT OUTER  JOIN PRC_REGIAO_FILIAL_PRC_FILIAL ON
			META.CD_EMP = PRC_REGIAO_FILIAL_PRC_FILIAL.CD_EMP AND
			META.CD_FILIAL = PRC_REGIAO_FILIAL_PRC_FILIAL.CD_FILIAL 
			LEFT OUTER  JOIN PRC_REGIAO_FILIAL ON
			PRC_REGIAO_FILIAL_PRC_FILIAL.CD_EMP = PRC_REGIAO_FILIAL.CD_EMP AND
			PRC_REGIAO_FILIAL_PRC_FILIAL.CD_REGIAO_FILIAL = PRC_REGIAO_FILIAL.CD_REGIAO_FILIAL 
			LEFT OUTER JOIN GLB_USU ON
			PRC_REGIAO_FILIAL.CD_USU_SUPERVISOR = GLB_USU.CD_USU 
			INNER JOIN PRC_FILIAL ON
			META.CD_EMP = PRC_FILIAL.CD_EMP AND
			META.CD_FILIAL = PRC_FILIAL.CD_FILIAL 
			INNER JOIN GLB_CID ON
			PRC_FILIAL.CD_CID = GLB_CID.CD_CID
			LEFT OUTER JOIN FP_FUNC ON 
			META.CD_VEND = FP_FUNC.CD_FUN 
	GROUP BY
			META.CD_EMP
			,META.CD_FILIAL
			,META.DT_VD
			,META.VENDA_RECARGA
			,META.PERC_LUCRATIVIDADE
			,PRC_REGIAO_FILIAL.NM_REGIAO_FILIAL
			,GLB_USU.NM_USU
			,PRC_FILIAL.NM_FANT
			,GLB_CID.DS_CID
			,GLB_CID.UF
			,PRC_FILIAL.CEP,TIPO_VENDA
			,META.CD_VEND
			,FP_FUNC.NM_FUN
